<?php
if ( ! _ROOT_ ) exit;
// ----- Affiche arborescence ----- Auteur : fgauharou@yahoo.fr ------------- //
// ----- Modifi le 07/11/03 par  --- christophe.perez@novazur.com ---------- //
// Version : 0.6.8

// CONSTANTES
// chemin du dossier contenant les icnes et images
define('_DOSSIERIMAGE_',"/imagesdir");
// liste des extensions de fichier  ne pas afficher, spare par un/des espace(s) ou tabulation(s)
define('_EXTINTERDITE_', "php");
// nombre de jour d'anciennet pour ne pas afficher le "nouveau"
define('_NBJOURANCIEN_', 10 );

// ----------------------------- Fonctions de gestion du chemin --------------------------- //
// enlve le dernier / et ce qui suit du nom de chemin
function ModifChemin($chemin)
{
	return ereg_replace("/[^/]*$","",$chemin);
}
// enlve ce qui suit le dernier / du nom de chemin
function Suppr_FinChemin($chemin)
{
	if ( ereg("/.*/",$chemin) )		return ereg_replace("/[^/]*$","",$chemin);
	else							return ereg_replace("[^/]*$","",$chemin);
}

function DecomposerChemin($chemin)
{
	$depart = Suppr_FinChemin($_SERVER["SCRIPT_NAME"]);
	$chemin_suiv = ereg_replace("^".$depart,"",$chemin);
	$chemindecompose = '<a href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.$depart.'">'.$depart.'</a>';
	if ( $chemin_suiv )
		for ($i = 0 , $chemin_tabl = explode("/",$chemin_suiv), $chemin_lien = $chemin_reel = "" ; $i < sizeof($chemin_tabl) ; $i++ ) {
			$chemin_reel .= "/".$chemin_tabl[$i];
			$chemindecompose .= '<a href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.$chemin_reel.'">'.utf8_decode($chemin_tabl[$i]).'</a> / ';
		}
	return $chemindecompose;
}

// =================== Fonction de gestions des extension et icnes =========== //

function GetIcone($ext)
{
	switch($ext)
	{
		case "jpg"  :
		case "gif"  :
		case "png"  :
		case "bmp"  :
		case "tif"  : $icone = "image1.gif";			break;
		case "mpg"  :
		case "mpeg"  :
		case "avi"  :
		case "mov"  : $icone = "movie.gif";			break;
		case "pdf"  : $icone = "pdf.gif";			break;
		case "rpm"  : $icone = "rpm.gif";			break;
		case "zip"  :
		case "ace"  :
		case "tar"  :
		case "gz"   :
		case "tgz"  :
		case "jar"  :
		case "xpi"  :
		case "bz2"  :
		case "uu"   : $icone = "zip.gif";			break;
		case "bat"  : $icone = "bat.gif";			break;
		case "sql"  :
		case "txt"  : $icone = "text.gif";			break;
		case "mp3"  :
		case "wav"  :
		case "au"   :
		case "ogg"   :
		case "mid"  : $icone = "sound.gif";			break;
		case "rtf"  : $icone = "quill.gif";			break;
		case "doc"  : $icone = "doc.gif";			break;
		case "xls"  : $icone = "excel.gif";			break;
		case "ppt"  : $icone = "ppt.gif";			break;
		case "rdf"  :
		case "xul"  :
		case "js"   :
		case "c"    :
		case "cpp"  :
		case "asp"  :
		case "css"  :
		case "inc"  :
		case "ps"   :
		case "pps"  :
		case "php"  :
		case "php3" :
		case "php4" : $icone = "script.gif";			break;
		case "com"  : $icone = "com.gif";			break;
		case "html" :
		case "htm"  : $icone = "html.gif";			break;
		case "exe"  : $icone = "exe.gif";			break;
		default     : $icone = "unknown.gif";		break;
	}
    return $icone;
}

function GetExtension($fichier)
{
	$extension = "";
	if ( strpos($fichier,".") )
		$extension = ereg_replace(".*\.","",$fichier);
	return $extension;
}

// ----------------------- Fonction de gestions de la taille du fichier ------------------------ //

function FormatTailleFichier($Taille)
{
	if ($Taille == 0)						$format = "vide";
	elseif ($Taille <= 1024)				$format = $Taille." oct";
	elseif ($Taille <= (10*1024))			$format = sprintf ("%.2f k%s",($Taille/1024),"o");
	elseif ($Taille <= (100*1024))			$format = sprintf ("%.1f k%s",($Taille/1024),"o");
	elseif ($Taille <= (1024*1024))			$format = sprintf ("%d k%s",($Taille/1024),"o");
	elseif ($Taille <= (10*1024*1024))		$format = sprintf ("%.2f M%s",($Taille/(1024*1024)),"o");
	elseif ($Taille <= (100*1024*1024))		$format = sprintf ("%.1f M%s",($Taille/(1024*1024)),"o");
	else									$format = sprintf ("%d M%s",($Taille/(1024*1024)),"o");

	return $format;
}

// ----------------------- Fonction de rcupration taille rpertoire ------------------------ //

function repsize( $Repertoire )
{
	$taille = 0;
	$Handle = opendir( $Repertoire );
	while($Object = readdir( $Handle )) {
	  	if ((is_dir( $Repertoire ."/". $Object)) && ( $Object != "." ) && ( $Object != ".." ))//Si ce chemin est un sous-rpertoire.
   			$taille += repsize( $Repertoire."/".$Object );
	  	elseif (is_file( $Repertoire ."/". $Object )) {	//Si ce chemin est un fichier.
			$taille += filesize( $Repertoire."/".$Object );
		}
	}
	closedir( $Handle );
	return $taille;
}

// ----------------------- Fonction de traitement anciennet fichier ------------------------ //

function ancienete($timestamp) {
	if ( (time() - $timestamp) <  ( _NBJOURANCIEN_ * 24 * 60 * 60 ) )		return TRUE;
	else																	return FALSE;
}

// ----------------------- Fonction de codage du nom  afficher ------------------------ //

function codageNom($nom_fichier) {
	$result = utf8_decode($nom_fichier); 				// pour dcoder l'utf8 du systme de fichier
	$result = ereg_replace('-','&#8209;',$result);		// pour remplacer les "-" par des "-" inscables
	return $result;
}

// ----------------------- Fonction Principale qui renvoie l'affichage ------------------------ //

function dir_affiche() {
	$chaine = "";
	$depart = $_SERVER["SCRIPT_NAME"];

// ------------------------------ Initialisation des variables ----------------------------------------------- //

	if ( isset($_GET["chemin"])
		&& strstr($_GET["chemin"],ereg_replace("[^/]*$","",$depart))
		&& !strstr(rawurldecode($_GET['chemin']),'/..')
		&& is_dir(_ROOT_.$_GET["chemin"])
	)
		$chemin = rawurldecode($_GET["chemin"]);
	else
		$chemin = ModifChemin($depart);

// ----------------------------------- Scurit navigation -------------------------------------------------- //

	$chemintotal = _ROOT_.$chemin;

// ------------------------------- Rcupration des fichiers et rpertoires dans tableau-- //

	$handle  = @opendir($chemintotal);
	$file    = @readdir($handle);      // repertoire .
	$file    = @readdir($handle);      // repertoire ..
	$repind  = $fileind = 0;

	while ($file = @readdir($handle) ) {
		if ( $fichier = @fopen("$chemintotal/$file.comment","r" ) ) {
			$comment = ereg_replace("\n$","",@fread($fichier, 4096));
		} else $comment = "";
		$timestamp = @filemtime("$chemintotal/$file");
		$new = $timestamp ? ancienete($timestamp) : FALSE;
		$date = str_replace(" ","&nbsp;",date("d/m/y H:i",$timestamp));
		$interdit = (_EXTINTERDITE_ && ereg("(".preg_replace("/\s+/","|",_EXTINTERDITE_).")", GetExtension($file)));
		if ( substr($comment,0,10) != "no-display" && !$interdit ) {
			if (@is_dir("$chemintotal/$file") && !ereg('^\.',$file) ) {
				$reptab_nom[$repind]			= $file;
				$reptab_tail[$repind]			= repsize("$chemintotal/$file");
				$reptab_comm[$repind]			= $comment;
				$reptab_date[$repind]			= $date;
				$reptab_new[$repind]			= $new;
				$repind++;
			} elseif (
				@is_file("$chemintotal/$file")
				&& ($chemin != $depart || !strstr($_SERVER["SCRIPT_NAME"], $file))
				&& GetExtension($file) != "comment"
				&& !ereg('^\.',$file)
			) {
				$filetab_nom[$fileind]			= $file;
				$filetab_tail[$fileind]			= @filesize("$chemintotal/$file");
				$filetab_comm[$fileind]			= $comment;
				$filetab_date[$fileind]			= $date;
				$filetab_new[$fileind]			= $new;
				$fileind++;
			}
		}
	}

	@closedir($handle);


// ------------- rcupration d'un commentaire de rpertoire -------------------------

	if ( $fichier = @fopen("$chemintotal/repertoire.comment","r" ) ) {
			$comment = nl2br(@fread($fichier, 4096));
	} else $comment = "";


// ============================ Tri des Tableaux ============================= //
	if ( isset($reptab_nom) )	array_multisort($reptab_nom,$reptab_tail,$reptab_comm,$reptab_date,$reptab_new);
	if ( isset($filetab_nom) )	array_multisort($filetab_nom,$filetab_tail,$filetab_comm,$filetab_date,$filetab_new);

// ============================= Affichage =================================== //
	if ( $comment ) $chaine .= '
<div id="rep_comment">
	'.$comment.'
</div>
';

	$chaine .= '
<script type="text/javascript">
<!--
function changecoul(Cel,Color,typ){
	if ( Cel.className == "dir_"+typ+Color )	Cel.className = "dir_"+typ+"on";
	else										Cel.className = "dir_"+typ+Color;
}
//-->
</script>

<div class="dir_ent">
	Rpertoire : '.DecomposerChemin($chemin).'
</div>
<table class="dir_tabl">
	<tr>
		<th></th>
		<th>Nom</th>
		<th>Date</th>
		<th>Taille</th>
		<th>Commentaire</th>
	</tr>
';
// ------ Si sous-rpertoire --------------- //

	if($chemin && $chemin != Suppr_FinChemin($depart))
	{
		$cheminretour = rawurlencode(ModifChemin($chemin));
		$chaine .= '
	<tr id="dir_racine" class="dir_rep0" onmouseover="changecoul(this,0,\'rep\');" onmouseout="changecoul(this,0,\'rep\');" onclick=\'location.href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.$cheminretour.'";\'>
		<td class="dir_icone"><a href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.$cheminretour.'"><img src="'._DOSSIERIMAGE_.'/back.gif" alt="remonter" /></a></td>
		<td class="dir_rep"><a href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.$cheminretour.'">..</a></td>
		<td></td>
		<td></td>
		<td></td>
	</tr>
';
	}

// -------------------------------------- Affichage des rpertoires --------------------------------------- //

	for($i=0;$i<$repind;$i++)
	{
		$lien = '<a href="'.$_SERVER["SCRIPT_NAME"].'?chemin='.rawurlencode($chemin."/".$reptab_nom[$i]).'">';
		$new = ($reptab_new[$i]?'<div class="dir_new">Nouveau</div>':'');
		$chaine .= '
	<tr class="dir_rep'.(2-$i%2).'" onmouseover="changecoul(this,'.(2-$i%2).',\'rep\');" onmouseout="changecoul(this,'.(2-$i%2).',\'rep\');">
		<td class="dir_icone">'.$lien.'<img src="'._DOSSIERIMAGE_.'/dir.gif" alt="repertoire" /></a></td>
		<td class="dir_nom">'.$new.'<div>'.$lien.codageNom($reptab_nom[$i]).'</a></div></td>
		<td class="dir_date">'.$reptab_date[$i].'</td>
		<td class="dir_tail">'.ereg_replace(" ","&nbsp;",FormatTailleFichier($reptab_tail[$i])).'</td>
		<td class="dir_comment">'.nl2br($reptab_comm[$i]).'</td>
	</tr>
';
	}

// --------------------------------------- Affichage des fichiers ----------------------------------------- //

	for($i=0;$i<$fileind;$i++)
	{
		$get = dirname($_SERVER["SCRIPT_NAME"]).( ereg('/$',dirname($_SERVER["SCRIPT_NAME"]))?'':'/' ).'get.php';
		$lien =  '<a href="'.(is_file(_ROOT_.$get) ? $get.'?fichier='.rawurlencode($chemin."/".$filetab_nom[$i]) : $chemin."/".$filetab_nom[$i] ).'">';
		$icone = GetIcone(strtolower(GetExtension($filetab_nom[$i])));
		$new = ($filetab_new[$i]?'<div class="dir_new">Nouveau</div>':'');
		$chaine .= '
	<tr class="dir_fil'.(2-$i%2).'" onmouseover="changecoul(this,'.(2-$i%2).',\'fil\');" onmouseout="changecoul(this,'.(2-$i%2).',\'fil\');">
		<td class="dir_icone">'.$lien.'<img src="'._DOSSIERIMAGE_.'/'.$icone.'" alt="icone fichier" /></a></td>
		<td class="dir_nom">'.$new.'<div>'.$lien.codageNom($filetab_nom[$i]).'</a></div></td>
		<td class="dir_date">'.$filetab_date[$i].'</td>
		<td class="dir_tail">'.ereg_replace(" ","&nbsp;",FormatTailleFichier($filetab_tail[$i])).'</td>
		<td class="dir_comment">'.nl2br($filetab_comm[$i]).'</td>
	</tr>
';
	}

// ------ fin du tableau ---- //

	$chaine .= '
</table>
<div class="dir_ent">
	Nombre de dossier(s) : '.$repind.' - Nombre de fichier(s) : '.$fileind.'
</div>
<div id="signature">
	<a href="http://www.novazur.com">
		<img src="http://www.novazur.com/logo.php" alt="Crateur" />
	</a>
</div>
<hr style="visibility: hidden; clear: both; margin: 0; border: 0; padding: 0; height: 0; line-height: 0;" />
';
	return $chaine;

}
